import React, {Component} from 'react';
import PropTypes from 'prop-types';
import {Modal, ModalBody, ModalHeader} from "reactstrap";
import {graphql, compose} from "react-apollo";
import gql from 'graphql-tag'
import BlinkDot from "../../../../../core/Loading/BlinkDot";
import Ionicon from "react-ionicons";

class MonitoraggioSpecieFilters extends Component {
  static propTypes = {
    onFilterChange: PropTypes.func.isRequired
  };

  constructor(props) {
    super(props);
    this.state = {
      filter: ''
    };

    this.handleFiltersChange = this.handleFiltersChange.bind(this);
  }

  handleFiltersChange(event) {
    this.setState({filter: event.target.value});
    this.props.onFilterChange(event.target.value);
  }

  render() {
    return (<div style={{margin: '10px 0'}} className="card">
      <div className="card-body">
        <form>
          <div className="form-group row">
            <label className="col-sm-2 col-form-label" htmlFor="filter-monitoraggio-specie" >Filtro</label>
            <div className="col-sm-8">
              <input
                className="form-control"
                id="filter-monitoraggio-specie"
                type="text"
                onChange={this.handleFiltersChange}
                value={this.state.filter}/>
            </div>
          </div>
        </form>
      </div>
    </div>);
  }
}

export default MonitoraggioSpecieFilters;